using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Text;
using System.Data.SqlClient;
using System.Drawing;
using System.Windows.Forms;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.GUI
{
	// Developer notes:
	// This form actually encompasses two different sets of functionality/ use cases.  The first
    // is the maintenance of Special Instructions (UC37) and the second is Transfusion Requirments 
	// (UC38).  Whenever the use cases required separate code, I noted this with regions.
	//  - Carl Jensen 4/17/2003
	//
	// This UC has too much logic in the Presentation Layer.  A new BOL object should be created 
	// to manage the display, creation and inactivation of SIs/ TRs.
	//

	/// <summary>
	/// Provides User Interface for the entry of Special Instructions (UC37) as well as Transfusion requirements (UC38).
	/// Since this functionality encompasses two use cases, the code has been broken down into regions that reflect this.
	/// </summary>
	///<remarks>
	///<newpara> Package: VBECS - VistA Blood Establishment Computer System</newpara>
	///<newpara> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</newpara>
	///<newpara> Medical Device #: $MEDDEVICENO</newpara>
	///<newpara> Date Created: 4/7/2003</newpara>
	///<newpara> Site Name: Hines OIFO </newpara>
	///<newpara> Developers: Carl Jensen</newpara>
	///<newpara> Note: The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</newpara>
	///</remarks>
	public class FrmDefineTransfusionReqs : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region constants
		
		private const short ANTIGEN = 1;
		private const short COMPONENT = 2;
		private const short ANTIBODY = 3;
		
		#endregion


		#region variables


		#region UC37variables

		private ArrayList _specialInstructions;
		private ArrayList _newSpecialInstruction;
		private bool _showInactiveSIs;
		
		DataTable _dtInsertSpecialInstructions;
		DataTable _dtUpdateSpecialInstructions;
	    private bool _removeSI;
	    private bool _removeTR;

		#endregion


		#region UC38Variables

		private bool _showInactiveCRs;
		private ArrayList _componentRequirements;
		private ArrayList _newComponentRequirements;

		private bool _showInactiveANs;
		private ArrayList _antigenNegatives;
		private ArrayList _newAntigenNegatives;

		private bool _showInactiveAIs;
		private ArrayList _antibodies;
		private ArrayList _newAntibodies;

		private ArrayList _inactivatedList;

		System.Data.DataTable _dtANs;
		System.Data.DataTable _dtARs;
		System.Data.DataTable _dtCRs;

		DataTable _dtInsertTransfusionRequirements;
		DataTable _dtUpdateTransfusionRequirements;
		
		#endregion
		
		// used when this UC is called from a UC that is supplying the patient
		private BOL.Patient _patient;
		private bool _loading;
		
		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Panel pnlTransfusionRequirements;
		private System.Windows.Forms.TabControl tabTransfusionRequirements;
		private System.Windows.Forms.TabPage pageComponentAttribute;
		private System.Windows.Forms.GroupBox grpExistingComponentAttributes;
		private System.Windows.Forms.CheckBox cbShowInactiveComponentRequirements;
		private System.Windows.Forms.ListView lvComponentAttributes;
		private System.Windows.Forms.GroupBox grpNewComponentAttribute;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSpecialRequirement;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAddComponentAttribute;
		private System.Windows.Forms.Label lblAttribute;
		private System.Windows.Forms.TabPage pageAntigenNegative;
		private System.Windows.Forms.GroupBox grpExistingAntigens;
		private System.Windows.Forms.CheckBox cbShowInactiveAntigens;
		private System.Windows.Forms.ListView lvAntigenNegative;
		private System.Windows.Forms.GroupBox grpNewAntigen;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAddAntigenScreen;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAntigen;
		private System.Windows.Forms.Label lblAntigen;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.ColumnHeader columnHeader2;
		private System.Windows.Forms.ColumnHeader columnHeader7;
		private System.Windows.Forms.ColumnHeader columnHeader4;
		private System.Windows.Forms.ColumnHeader columnHeader5;
		private System.Windows.Forms.ColumnHeader columnHeader8;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.PatientSelectTool patientSelectTool1;
		private System.Windows.Forms.TabPage pageSpecialInstructions;
		private System.Windows.Forms.GroupBox grpNewInstruction;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbSpecialInstruction;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAdd;
		private System.Windows.Forms.Label lblInstruction;
		private System.Windows.Forms.GroupBox grpInstructions;
		private System.Windows.Forms.CheckBox cbShowInactive;
		private System.Windows.Forms.ListView lvInstructions;
		private System.Windows.Forms.ColumnHeader columnHeader10;
		private System.Windows.Forms.ColumnHeader columnHeader11;
		private System.Windows.Forms.ColumnHeader columnHeader12;
		private System.Windows.Forms.ColumnHeader columnHeader3;
		private System.Windows.Forms.ColumnHeader columnHeader6;
		private System.Windows.Forms.ColumnHeader columnHeader9;
		private System.Windows.Forms.TabPage pageAntibodyIDs;
		private System.Windows.Forms.ColumnHeader columnHeader13;
		private System.Windows.Forms.ColumnHeader columnHeader14;
		private System.Windows.Forms.ColumnHeader columnHeader15;
		private System.Windows.Forms.ColumnHeader columnHeader16;
		private System.Windows.Forms.GroupBox groupBox2;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbAntibody;
		private System.Windows.Forms.Label lblAntibody;
		private System.Windows.Forms.GroupBox grpAntibodies;
		private System.Windows.Forms.CheckBox cbShowInactiveAntibodies;
		private System.Windows.Forms.ListView lvAntibodies;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnAntibodyAdd;
		private System.Windows.Forms.ColumnHeader columnHeader17;
		private System.Windows.Forms.ColumnHeader columnHeader18;
		private System.Windows.Forms.ColumnHeader columnHeader19;
        private System.Windows.Forms.ColumnHeader columnHeader20;
        private controls.PatientDisplayPanel patientDisplayPanel1;
		private System.ComponentModel.IContainer components = null;

		#endregion


		#region constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmDefineTransfusionReqs()
		{
			this.LockController.LockFunction = Common.LockFunctions.UC038DefinePatientTransfusionRequirements;

			InitializeComponent();
			SetComponentProperties(false);
			this.cmbSpecialInstruction.Focus();
		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="patient"></param>
		public FrmDefineTransfusionReqs(BOL.Patient patient)
		{
			this.LockController.LockFunction = Common.LockFunctions.UC038DefinePatientTransfusionRequirements;

			//It may look like we're locking the PatientGuid, but inside SetLocks is functionality
			//that essentially just locks UC37/38 for this patient
			if (!this.LockUseCase(patient.PatientGuid))
			{
				//This should return back to UC_56 where the DialogResult will be checked for Abort
				this.DialogResult = DialogResult.Abort;
				return;
			}

			InitializeComponent();
			SetComponentProperties(true);
			this._patient = patient;
		
			this.patientSelectTool1.Visible = false;
			this.pnlTransfusionRequirements.Visible = true;
			this.tabTransfusionRequirements.Visible = true;
			this.PopulateComboBoxes();
			
			// UC37 - initialize ArrayLists
			this.ConvertToObjects(patient.SpecialInstructions, true);
			// UC38 - initialize ArrayLists
			this.ConvertToObjects(patient.TransfusionRequirements, false);
			
			this.patientDisplayPanel1.Patient = patient;
			this.patientDisplayPanel1.PatientInfoToolbar.EnabledSIAndTRButton = false;
			this.LoadListView37();
			// Load combo boxes for UC38
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.ComponentRequirement);
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntigenNegative);
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntibodyIdentified);
			this.cmbSpecialInstruction.Focus();
		}

		#endregion


		#region methods

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
            this.components = new System.ComponentModel.Container();
            System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(FrmDefineTransfusionReqs));
            this.btnCancel = new System.Windows.Forms.Button();
            this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.cmbAntigen = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.cmbAntibody = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.pnlTransfusionRequirements = new System.Windows.Forms.Panel();
            this.patientDisplayPanel1 = new gov.va.med.vbecs.GUI.controls.PatientDisplayPanel();
            this.grpImage = new System.Windows.Forms.GroupBox();
            this.pictureBox1 = new System.Windows.Forms.PictureBox();
            this.tabTransfusionRequirements = new System.Windows.Forms.TabControl();
            this.pageSpecialInstructions = new System.Windows.Forms.TabPage();
            this.grpNewInstruction = new System.Windows.Forms.GroupBox();
            this.cmbSpecialInstruction = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.btnAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblInstruction = new System.Windows.Forms.Label();
            this.grpInstructions = new System.Windows.Forms.GroupBox();
            this.cbShowInactive = new System.Windows.Forms.CheckBox();
            this.lvInstructions = new System.Windows.Forms.ListView();
            this.columnHeader10 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader11 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader3 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader12 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader17 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.pageAntigenNegative = new System.Windows.Forms.TabPage();
            this.grpExistingAntigens = new System.Windows.Forms.GroupBox();
            this.cbShowInactiveAntigens = new System.Windows.Forms.CheckBox();
            this.lvAntigenNegative = new System.Windows.Forms.ListView();
            this.columnHeader4 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader5 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader9 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader8 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader19 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpNewAntigen = new System.Windows.Forms.GroupBox();
            this.btnAddAntigenScreen = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblAntigen = new System.Windows.Forms.Label();
            this.pageComponentAttribute = new System.Windows.Forms.TabPage();
            this.grpExistingComponentAttributes = new System.Windows.Forms.GroupBox();
            this.cbShowInactiveComponentRequirements = new System.Windows.Forms.CheckBox();
            this.lvComponentAttributes = new System.Windows.Forms.ListView();
            this.columnHeader1 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader2 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader6 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader7 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader18 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.grpNewComponentAttribute = new System.Windows.Forms.GroupBox();
            this.cmbSpecialRequirement = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
            this.btnAddComponentAttribute = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblAttribute = new System.Windows.Forms.Label();
            this.pageAntibodyIDs = new System.Windows.Forms.TabPage();
            this.grpAntibodies = new System.Windows.Forms.GroupBox();
            this.cbShowInactiveAntibodies = new System.Windows.Forms.CheckBox();
            this.lvAntibodies = new System.Windows.Forms.ListView();
            this.columnHeader13 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader14 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader15 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader16 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.columnHeader20 = ((System.Windows.Forms.ColumnHeader)(new System.Windows.Forms.ColumnHeader()));
            this.groupBox2 = new System.Windows.Forms.GroupBox();
            this.btnAntibodyAdd = new gov.va.med.vbecs.GUI.controls.VbecsButton();
            this.lblAntibody = new System.Windows.Forms.Label();
            this.patientSelectTool1 = new gov.va.med.vbecs.GUI.controls.PatientSelectTool();
            ((System.ComponentModel.ISupportInitialize)(this.errError)).BeginInit();
            this.pnlTransfusionRequirements.SuspendLayout();
            this.grpImage.SuspendLayout();
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).BeginInit();
            this.tabTransfusionRequirements.SuspendLayout();
            this.pageSpecialInstructions.SuspendLayout();
            this.grpNewInstruction.SuspendLayout();
            this.grpInstructions.SuspendLayout();
            this.pageAntigenNegative.SuspendLayout();
            this.grpExistingAntigens.SuspendLayout();
            this.grpNewAntigen.SuspendLayout();
            this.pageComponentAttribute.SuspendLayout();
            this.grpExistingComponentAttributes.SuspendLayout();
            this.grpNewComponentAttribute.SuspendLayout();
            this.pageAntibodyIDs.SuspendLayout();
            this.grpAntibodies.SuspendLayout();
            this.groupBox2.SuspendLayout();
            this.SuspendLayout();
            // 
            // vbecsLogo1
            // 
            this.vbecsLogo1.Size = new System.Drawing.Size(692, 30);
            this.vbecsLogo1.TabIndex = 4;
            this.vbecsLogo1.Title = "Enter Patient Special Instructions and Transfusion Requirements ";
            // 
            // lblRequiredField
            // 
            this.lblRequiredField.TabIndex = 5;
            // 
            // btnCancel
            // 
            this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
            this.btnCancel.Location = new System.Drawing.Point(612, 444);
            this.btnCancel.Name = "btnCancel";
            this.btnCancel.Size = new System.Drawing.Size(75, 23);
            this.btnCancel.TabIndex = 19;
            this.btnCancel.Text = "&Cancel";
            this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
            // 
            // btnOK
            // 
            this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
            this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
            this.btnOK.Location = new System.Drawing.Point(532, 444);
            this.btnOK.Name = "btnOK";
            this.btnOK.Size = new System.Drawing.Size(75, 23);
            this.btnOK.TabIndex = 18;
            this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
            // 
            // cmbAntigen
            // 
            this.cmbAntigen.AccessibleDescription = "Antigen";
            this.cmbAntigen.AccessibleName = "Antigen";
            this.cmbAntigen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbAntigen.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbAntigen.Interval = 500;
            this.cmbAntigen.Location = new System.Drawing.Point(136, 20);
            this.cmbAntigen.MaxLength = 10;
            this.cmbAntigen.Name = "cmbAntigen";
            this.cmbAntigen.Size = new System.Drawing.Size(472, 22);
            this.cmbAntigen.TabIndex = 6;
            this.cmbAntigen.SelectedIndexChanged += new System.EventHandler(this.cmbAntigen_SelectedIndexChanged);
            this.cmbAntigen.SelectedValueChanged += new System.EventHandler(this.cmbAntigen_SelectedIndexChanged);
            // 
            // cmbAntibody
            // 
            this.cmbAntibody.AccessibleDescription = "Antibody";
            this.cmbAntibody.AccessibleName = "Antibody";
            this.cmbAntibody.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbAntibody.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbAntibody.Interval = 500;
            this.cmbAntibody.Location = new System.Drawing.Point(136, 20);
            this.cmbAntibody.Name = "cmbAntibody";
            this.cmbAntibody.Size = new System.Drawing.Size(472, 22);
            this.cmbAntibody.TabIndex = 14;
            this.cmbAntibody.SelectedIndexChanged += new System.EventHandler(this.cmbAntibody_SelectedIndexChanged);
            this.cmbAntibody.SelectedValueChanged += new System.EventHandler(this.cmbAntibody_SelectedIndexChanged);
            this.cmbAntibody.TextChanged += new System.EventHandler(this.cmbAntibody_SelectedIndexChanged);
            // 
            // pnlTransfusionRequirements
            // 
            this.pnlTransfusionRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.pnlTransfusionRequirements.Controls.Add(this.patientDisplayPanel1);
            this.pnlTransfusionRequirements.Controls.Add(this.grpImage);
            this.pnlTransfusionRequirements.Controls.Add(this.tabTransfusionRequirements);
            this.pnlTransfusionRequirements.Location = new System.Drawing.Point(0, 36);
            this.pnlTransfusionRequirements.Name = "pnlTransfusionRequirements";
            this.pnlTransfusionRequirements.Size = new System.Drawing.Size(692, 404);
            this.pnlTransfusionRequirements.TabIndex = 1;
            // 
            // patientDisplayPanel1
            // 
            this.patientDisplayPanel1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientDisplayPanel1.EnabledBloodAvailButton = false;
            this.patientDisplayPanel1.EnabledMedicationButton = false;
            this.patientDisplayPanel1.EnabledRecentOrdersButton = false;
            this.patientDisplayPanel1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientDisplayPanel1.EnabledSIAndTRButton = false;
            this.patientDisplayPanel1.EnabledTransfusionReactionHistoryButton = false;
            this.patientDisplayPanel1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.patientDisplayPanel1.Location = new System.Drawing.Point(4, 0);
            this.patientDisplayPanel1.Name = "patientDisplayPanel1";
            this.patientDisplayPanel1.Patient = null;
            this.patientDisplayPanel1.Size = new System.Drawing.Size(688, 44);
            this.patientDisplayPanel1.TabIndex = 2;
            // 
            // grpImage
            // 
            this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left)));
            this.grpImage.Controls.Add(this.pictureBox1);
            this.grpImage.Location = new System.Drawing.Point(4, 40);
            this.grpImage.Name = "grpImage";
            this.grpImage.Size = new System.Drawing.Size(40, 360);
            this.grpImage.TabIndex = 1;
            this.grpImage.TabStop = false;
            // 
            // pictureBox1
            // 
            this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
            this.pictureBox1.Location = new System.Drawing.Point(4, 12);
            this.pictureBox1.Name = "pictureBox1";
            this.pictureBox1.Size = new System.Drawing.Size(32, 32);
            this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
            this.pictureBox1.TabIndex = 1;
            this.pictureBox1.TabStop = false;
            // 
            // tabTransfusionRequirements
            // 
            this.tabTransfusionRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.tabTransfusionRequirements.Controls.Add(this.pageSpecialInstructions);
            this.tabTransfusionRequirements.Controls.Add(this.pageAntigenNegative);
            this.tabTransfusionRequirements.Controls.Add(this.pageComponentAttribute);
            this.tabTransfusionRequirements.Controls.Add(this.pageAntibodyIDs);
            this.tabTransfusionRequirements.Location = new System.Drawing.Point(48, 44);
            this.tabTransfusionRequirements.Name = "tabTransfusionRequirements";
            this.tabTransfusionRequirements.SelectedIndex = 0;
            this.tabTransfusionRequirements.Size = new System.Drawing.Size(640, 356);
            this.tabTransfusionRequirements.TabIndex = 1;
            this.tabTransfusionRequirements.Visible = false;
            this.tabTransfusionRequirements.SelectedIndexChanged += new System.EventHandler(this.tabTransfusionRequirements_SelectedIndexChanged);
            // 
            // pageSpecialInstructions
            // 
            this.pageSpecialInstructions.Controls.Add(this.grpNewInstruction);
            this.pageSpecialInstructions.Controls.Add(this.grpInstructions);
            this.pageSpecialInstructions.Location = new System.Drawing.Point(4, 23);
            this.pageSpecialInstructions.Name = "pageSpecialInstructions";
            this.pageSpecialInstructions.Size = new System.Drawing.Size(632, 329);
            this.pageSpecialInstructions.TabIndex = 3;
            this.pageSpecialInstructions.Text = "Special Instructions";
            // 
            // grpNewInstruction
            // 
            this.grpNewInstruction.AccessibleDescription = "New Special Instruction";
            this.grpNewInstruction.AccessibleName = "New Special Instruction";
            this.grpNewInstruction.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpNewInstruction.Controls.Add(this.cmbSpecialInstruction);
            this.grpNewInstruction.Controls.Add(this.btnAdd);
            this.grpNewInstruction.Controls.Add(this.lblInstruction);
            this.grpNewInstruction.Location = new System.Drawing.Point(4, 4);
            this.grpNewInstruction.Name = "grpNewInstruction";
            this.grpNewInstruction.Size = new System.Drawing.Size(624, 76);
            this.grpNewInstruction.TabIndex = 0;
            this.grpNewInstruction.TabStop = false;
            this.grpNewInstruction.Text = "New Special Instruction";
            // 
            // cmbSpecialInstruction
            // 
            this.cmbSpecialInstruction.AccessibleDescription = "Special Instruction";
            this.cmbSpecialInstruction.AccessibleName = "Special Instruction";
            this.cmbSpecialInstruction.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbSpecialInstruction.Interval = 500;
            this.cmbSpecialInstruction.Location = new System.Drawing.Point(112, 20);
            this.cmbSpecialInstruction.LookupEnabled = false;
            this.cmbSpecialInstruction.MaxLength = 254;
            this.cmbSpecialInstruction.Name = "cmbSpecialInstruction";
            this.cmbSpecialInstruction.Size = new System.Drawing.Size(496, 22);
            this.cmbSpecialInstruction.TabIndex = 2;
            this.cmbSpecialInstruction.SelectedIndexChanged += new System.EventHandler(this.cmbSpecialInstruction_SelectedIndexChanged);
            this.cmbSpecialInstruction.TextChanged += new System.EventHandler(this.cmbSpecialInstruction_SelectedIndexChanged);
            // 
            // btnAdd
            // 
            this.btnAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAdd.EnabledButton = false;
            this.btnAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAdd.Image")));
            this.btnAdd.Location = new System.Drawing.Point(532, 48);
            this.btnAdd.Name = "btnAdd";
            this.btnAdd.Size = new System.Drawing.Size(75, 23);
            this.btnAdd.TabIndex = 3;
            this.btnAdd.Click += new System.EventHandler(this.btnAdd_Click);
            // 
            // lblInstruction
            // 
            this.lblInstruction.Location = new System.Drawing.Point(8, 20);
            this.lblInstruction.Name = "lblInstruction";
            this.lblInstruction.Size = new System.Drawing.Size(104, 20);
            this.lblInstruction.TabIndex = 0;
            this.lblInstruction.Text = "Special Instruction*";
            this.lblInstruction.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // grpInstructions
            // 
            this.grpInstructions.AccessibleDescription = "Existing Special Instructions";
            this.grpInstructions.AccessibleName = "Existing Special Instructions";
            this.grpInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpInstructions.Controls.Add(this.cbShowInactive);
            this.grpInstructions.Controls.Add(this.lvInstructions);
            this.grpInstructions.Location = new System.Drawing.Point(4, 84);
            this.grpInstructions.Name = "grpInstructions";
            this.grpInstructions.Size = new System.Drawing.Size(624, 244);
            this.grpInstructions.TabIndex = 1;
            this.grpInstructions.TabStop = false;
            this.grpInstructions.Text = "Existing Special Instructions";
            // 
            // cbShowInactive
            // 
            this.cbShowInactive.AccessibleDescription = "Show Inactive Special Instructions";
            this.cbShowInactive.AccessibleName = "Show Inactive Special Instructions";
            this.cbShowInactive.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactive.Location = new System.Drawing.Point(8, 220);
            this.cbShowInactive.Name = "cbShowInactive";
            this.cbShowInactive.Size = new System.Drawing.Size(600, 20);
            this.cbShowInactive.TabIndex = 5;
            this.cbShowInactive.Text = "Show Inactive &Special Instructions";
            this.cbShowInactive.Click += new System.EventHandler(this.cbShowInactive_Click);
            // 
            // lvInstructions
            // 
            this.lvInstructions.AccessibleDescription = "Existing Special Instructions";
            this.lvInstructions.AccessibleName = "Existing Special Instructions";
            this.lvInstructions.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvInstructions.CheckBoxes = true;
            this.lvInstructions.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader10,
            this.columnHeader11,
            this.columnHeader3,
            this.columnHeader12,
            this.columnHeader17});
            this.lvInstructions.FullRowSelect = true;
            this.lvInstructions.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvInstructions.Location = new System.Drawing.Point(8, 20);
            this.lvInstructions.MultiSelect = false;
            this.lvInstructions.Name = "lvInstructions";
            this.lvInstructions.Size = new System.Drawing.Size(600, 200);
            this.lvInstructions.TabIndex = 4;
            this.lvInstructions.UseCompatibleStateImageBehavior = false;
            this.lvInstructions.View = System.Windows.Forms.View.Details;
            this.lvInstructions.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.lvInstructions_ItemCheck);
            this.lvInstructions.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvInstructions_ItemChecked);
            this.lvInstructions.SelectedIndexChanged += new System.EventHandler(this.lvInstructions_SelectedIndexChanged);
            // 
            // columnHeader10
            // 
            this.columnHeader10.Text = "Active";
            this.columnHeader10.Width = 45;
            // 
            // columnHeader11
            // 
            this.columnHeader11.Text = "Special Instruction";
            this.columnHeader11.Width = 200;
            // 
            // columnHeader3
            // 
            this.columnHeader3.Text = "Creation Date, User";
            this.columnHeader3.Width = 110;
            // 
            // columnHeader12
            // 
            this.columnHeader12.Text = "Inactivation Date, User";
            this.columnHeader12.Width = 120;
            // 
            // columnHeader17
            // 
            this.columnHeader17.Text = "Inactivation Comment";
            this.columnHeader17.Width = 120;
            // 
            // pageAntigenNegative
            // 
            this.pageAntigenNegative.Controls.Add(this.grpExistingAntigens);
            this.pageAntigenNegative.Controls.Add(this.grpNewAntigen);
            this.pageAntigenNegative.Location = new System.Drawing.Point(4, 23);
            this.pageAntigenNegative.Name = "pageAntigenNegative";
            this.pageAntigenNegative.Size = new System.Drawing.Size(632, 329);
            this.pageAntigenNegative.TabIndex = 1;
            this.pageAntigenNegative.Text = "Antigen Negative RBCs";
            this.pageAntigenNegative.Visible = false;
            // 
            // grpExistingAntigens
            // 
            this.grpExistingAntigens.AccessibleDescription = "Existing Antigen Negative RBCs";
            this.grpExistingAntigens.AccessibleName = "Existing Antigen Negative RBCs";
            this.grpExistingAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpExistingAntigens.Controls.Add(this.cbShowInactiveAntigens);
            this.grpExistingAntigens.Controls.Add(this.lvAntigenNegative);
            this.grpExistingAntigens.Location = new System.Drawing.Point(4, 84);
            this.grpExistingAntigens.Name = "grpExistingAntigens";
            this.grpExistingAntigens.Size = new System.Drawing.Size(624, 244);
            this.grpExistingAntigens.TabIndex = 1;
            this.grpExistingAntigens.TabStop = false;
            this.grpExistingAntigens.Text = "Existing Antigen Negative RBCs";
            // 
            // cbShowInactiveAntigens
            // 
            this.cbShowInactiveAntigens.AccessibleDescription = "Show Inactive Antigen Negative RBCs";
            this.cbShowInactiveAntigens.AccessibleName = "Show Inactive Antigen Negative RBCs";
            this.cbShowInactiveAntigens.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactiveAntigens.Location = new System.Drawing.Point(8, 220);
            this.cbShowInactiveAntigens.Name = "cbShowInactiveAntigens";
            this.cbShowInactiveAntigens.Size = new System.Drawing.Size(592, 20);
            this.cbShowInactiveAntigens.TabIndex = 9;
            this.cbShowInactiveAntigens.Text = "Show Inactive Antigen &Negative RBCs";
            this.cbShowInactiveAntigens.Click += new System.EventHandler(this.cbShowInactiveAntigens_Click);
            // 
            // lvAntigenNegative
            // 
            this.lvAntigenNegative.AccessibleDescription = "Existing Antigen Negative RBCs";
            this.lvAntigenNegative.AccessibleName = "Existing Antigen Negative RBCs";
            this.lvAntigenNegative.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAntigenNegative.CheckBoxes = true;
            this.lvAntigenNegative.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader4,
            this.columnHeader5,
            this.columnHeader9,
            this.columnHeader8,
            this.columnHeader19});
            this.lvAntigenNegative.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvAntigenNegative.Location = new System.Drawing.Point(8, 20);
            this.lvAntigenNegative.Name = "lvAntigenNegative";
            this.lvAntigenNegative.Size = new System.Drawing.Size(600, 200);
            this.lvAntigenNegative.TabIndex = 8;
            this.lvAntigenNegative.UseCompatibleStateImageBehavior = false;
            this.lvAntigenNegative.View = System.Windows.Forms.View.Details;
            this.lvAntigenNegative.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.TRs_ItemCheck);
            this.lvAntigenNegative.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvAntigenNegative_ItemChecked);
            this.lvAntigenNegative.SelectedIndexChanged += new System.EventHandler(this.lvAntigenNegative_SelectedIndexChanged);
            // 
            // columnHeader4
            // 
            this.columnHeader4.Text = "Active";
            this.columnHeader4.Width = 45;
            // 
            // columnHeader5
            // 
            this.columnHeader5.Text = "Antigen Negative RBC";
            this.columnHeader5.Width = 120;
            // 
            // columnHeader9
            // 
            this.columnHeader9.Text = "Creation Date, User, Division";
            this.columnHeader9.Width = 150;
            // 
            // columnHeader8
            // 
            this.columnHeader8.Text = "Inactivation Date, User, Division";
            this.columnHeader8.Width = 165;
            // 
            // columnHeader19
            // 
            this.columnHeader19.Text = "Inactivation Comment";
            this.columnHeader19.Width = 115;
            // 
            // grpNewAntigen
            // 
            this.grpNewAntigen.AccessibleDescription = "New Antigen Negative RBC";
            this.grpNewAntigen.AccessibleName = "New Antigen Negative RBC";
            this.grpNewAntigen.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpNewAntigen.Controls.Add(this.btnAddAntigenScreen);
            this.grpNewAntigen.Controls.Add(this.cmbAntigen);
            this.grpNewAntigen.Controls.Add(this.lblAntigen);
            this.grpNewAntigen.Location = new System.Drawing.Point(4, 4);
            this.grpNewAntigen.Name = "grpNewAntigen";
            this.grpNewAntigen.Size = new System.Drawing.Size(624, 76);
            this.grpNewAntigen.TabIndex = 0;
            this.grpNewAntigen.TabStop = false;
            this.grpNewAntigen.Text = "New Antigen Negative RBC";
            // 
            // btnAddAntigenScreen
            // 
            this.btnAddAntigenScreen.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddAntigenScreen.EnabledButton = false;
            this.btnAddAntigenScreen.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAddAntigenScreen.Image = ((System.Drawing.Image)(resources.GetObject("btnAddAntigenScreen.Image")));
            this.btnAddAntigenScreen.Location = new System.Drawing.Point(532, 48);
            this.btnAddAntigenScreen.Name = "btnAddAntigenScreen";
            this.btnAddAntigenScreen.Size = new System.Drawing.Size(75, 23);
            this.btnAddAntigenScreen.TabIndex = 7;
            this.btnAddAntigenScreen.Click += new System.EventHandler(this.btnAddAntigenScreen_Click);
            // 
            // lblAntigen
            // 
            this.lblAntigen.Location = new System.Drawing.Point(8, 20);
            this.lblAntigen.Name = "lblAntigen";
            this.lblAntigen.Size = new System.Drawing.Size(100, 20);
            this.lblAntigen.TabIndex = 0;
            this.lblAntigen.Text = "Antigen*";
            this.lblAntigen.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pageComponentAttribute
            // 
            this.pageComponentAttribute.Controls.Add(this.grpExistingComponentAttributes);
            this.pageComponentAttribute.Controls.Add(this.grpNewComponentAttribute);
            this.pageComponentAttribute.Location = new System.Drawing.Point(4, 23);
            this.pageComponentAttribute.Name = "pageComponentAttribute";
            this.pageComponentAttribute.Size = new System.Drawing.Size(632, 329);
            this.pageComponentAttribute.TabIndex = 0;
            this.pageComponentAttribute.Text = "Component Requirements";
            // 
            // grpExistingComponentAttributes
            // 
            this.grpExistingComponentAttributes.AccessibleDescription = "Existing Component Requirements";
            this.grpExistingComponentAttributes.AccessibleName = "Existing Component Requirements";
            this.grpExistingComponentAttributes.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpExistingComponentAttributes.Controls.Add(this.cbShowInactiveComponentRequirements);
            this.grpExistingComponentAttributes.Controls.Add(this.lvComponentAttributes);
            this.grpExistingComponentAttributes.Location = new System.Drawing.Point(4, 84);
            this.grpExistingComponentAttributes.Name = "grpExistingComponentAttributes";
            this.grpExistingComponentAttributes.Size = new System.Drawing.Size(624, 244);
            this.grpExistingComponentAttributes.TabIndex = 1;
            this.grpExistingComponentAttributes.TabStop = false;
            this.grpExistingComponentAttributes.Text = "Existing Component Requirements";
            // 
            // cbShowInactiveComponentRequirements
            // 
            this.cbShowInactiveComponentRequirements.AccessibleDescription = "Show Inactive Component Requirements";
            this.cbShowInactiveComponentRequirements.AccessibleName = "Show Inactive Component Requirements";
            this.cbShowInactiveComponentRequirements.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactiveComponentRequirements.Location = new System.Drawing.Point(8, 220);
            this.cbShowInactiveComponentRequirements.Name = "cbShowInactiveComponentRequirements";
            this.cbShowInactiveComponentRequirements.Size = new System.Drawing.Size(592, 20);
            this.cbShowInactiveComponentRequirements.TabIndex = 13;
            this.cbShowInactiveComponentRequirements.Text = "Show Inactive Component &Requirements";
            this.cbShowInactiveComponentRequirements.Click += new System.EventHandler(this.cbShowInactiveComponentRequirements_Click);
            // 
            // lvComponentAttributes
            // 
            this.lvComponentAttributes.AccessibleDescription = "Existing Component Requirements";
            this.lvComponentAttributes.AccessibleName = "Existing Component Requirements";
            this.lvComponentAttributes.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvComponentAttributes.CheckBoxes = true;
            this.lvComponentAttributes.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader1,
            this.columnHeader2,
            this.columnHeader6,
            this.columnHeader7,
            this.columnHeader18});
            this.lvComponentAttributes.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvComponentAttributes.Location = new System.Drawing.Point(8, 20);
            this.lvComponentAttributes.Name = "lvComponentAttributes";
            this.lvComponentAttributes.Size = new System.Drawing.Size(600, 200);
            this.lvComponentAttributes.TabIndex = 12;
            this.lvComponentAttributes.UseCompatibleStateImageBehavior = false;
            this.lvComponentAttributes.View = System.Windows.Forms.View.Details;
            this.lvComponentAttributes.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.TRs_ItemCheck);
            this.lvComponentAttributes.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvComponentAttributes_ItemChecked);
            this.lvComponentAttributes.SelectedIndexChanged += new System.EventHandler(this.lvComponentAttributes_SelectedIndexChanged);
            // 
            // columnHeader1
            // 
            this.columnHeader1.Text = "Active";
            this.columnHeader1.Width = 45;
            // 
            // columnHeader2
            // 
            this.columnHeader2.Text = "Requirement";
            this.columnHeader2.Width = 120;
            // 
            // columnHeader6
            // 
            this.columnHeader6.Text = "Creation Date, User, Division";
            this.columnHeader6.Width = 150;
            // 
            // columnHeader7
            // 
            this.columnHeader7.Text = "Inactivation Date, User, Division";
            this.columnHeader7.Width = 165;
            // 
            // columnHeader18
            // 
            this.columnHeader18.Text = "Inactivation Comment";
            this.columnHeader18.Width = 115;
            // 
            // grpNewComponentAttribute
            // 
            this.grpNewComponentAttribute.AccessibleDescription = "New Component Requirement";
            this.grpNewComponentAttribute.AccessibleName = "New Component Requirement";
            this.grpNewComponentAttribute.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpNewComponentAttribute.Controls.Add(this.cmbSpecialRequirement);
            this.grpNewComponentAttribute.Controls.Add(this.btnAddComponentAttribute);
            this.grpNewComponentAttribute.Controls.Add(this.lblAttribute);
            this.grpNewComponentAttribute.Location = new System.Drawing.Point(4, 4);
            this.grpNewComponentAttribute.Name = "grpNewComponentAttribute";
            this.grpNewComponentAttribute.Size = new System.Drawing.Size(624, 76);
            this.grpNewComponentAttribute.TabIndex = 0;
            this.grpNewComponentAttribute.TabStop = false;
            this.grpNewComponentAttribute.Text = "New Component Requirement";
            // 
            // cmbSpecialRequirement
            // 
            this.cmbSpecialRequirement.AccessibleDescription = "Component Requirement";
            this.cmbSpecialRequirement.AccessibleName = "Component Requirement";
            this.cmbSpecialRequirement.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cmbSpecialRequirement.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList;
            this.cmbSpecialRequirement.Interval = 500;
            this.cmbSpecialRequirement.Location = new System.Drawing.Point(136, 20);
            this.cmbSpecialRequirement.Name = "cmbSpecialRequirement";
            this.cmbSpecialRequirement.Size = new System.Drawing.Size(472, 22);
            this.cmbSpecialRequirement.TabIndex = 10;
            this.cmbSpecialRequirement.SelectedIndexChanged += new System.EventHandler(this.cmbSpecialRequirement_SelectedIndexChanged);
            // 
            // btnAddComponentAttribute
            // 
            this.btnAddComponentAttribute.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAddComponentAttribute.EnabledButton = false;
            this.btnAddComponentAttribute.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAddComponentAttribute.Image = ((System.Drawing.Image)(resources.GetObject("btnAddComponentAttribute.Image")));
            this.btnAddComponentAttribute.Location = new System.Drawing.Point(532, 48);
            this.btnAddComponentAttribute.Name = "btnAddComponentAttribute";
            this.btnAddComponentAttribute.Size = new System.Drawing.Size(75, 23);
            this.btnAddComponentAttribute.TabIndex = 11;
            this.btnAddComponentAttribute.Click += new System.EventHandler(this.btnAddComponentAttribute_Click);
            // 
            // lblAttribute
            // 
            this.lblAttribute.Location = new System.Drawing.Point(8, 20);
            this.lblAttribute.Name = "lblAttribute";
            this.lblAttribute.Size = new System.Drawing.Size(136, 20);
            this.lblAttribute.TabIndex = 0;
            this.lblAttribute.Text = "Component Requirement*";
            this.lblAttribute.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // pageAntibodyIDs
            // 
            this.pageAntibodyIDs.Controls.Add(this.grpAntibodies);
            this.pageAntibodyIDs.Controls.Add(this.groupBox2);
            this.pageAntibodyIDs.Location = new System.Drawing.Point(4, 23);
            this.pageAntibodyIDs.Name = "pageAntibodyIDs";
            this.pageAntibodyIDs.Size = new System.Drawing.Size(632, 329);
            this.pageAntibodyIDs.TabIndex = 4;
            this.pageAntibodyIDs.Text = "Antibodies Identified";
            // 
            // grpAntibodies
            // 
            this.grpAntibodies.AccessibleDescription = "Existing Antibody Specificities Identified";
            this.grpAntibodies.AccessibleName = "Existing Antibody Specificities Identified";
            this.grpAntibodies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.grpAntibodies.Controls.Add(this.cbShowInactiveAntibodies);
            this.grpAntibodies.Controls.Add(this.lvAntibodies);
            this.grpAntibodies.Location = new System.Drawing.Point(4, 84);
            this.grpAntibodies.Name = "grpAntibodies";
            this.grpAntibodies.Size = new System.Drawing.Size(624, 244);
            this.grpAntibodies.TabIndex = 1;
            this.grpAntibodies.TabStop = false;
            this.grpAntibodies.Text = "Existing Antibody Specificities Identified";
            // 
            // cbShowInactiveAntibodies
            // 
            this.cbShowInactiveAntibodies.AccessibleDescription = "Show Inactive Antibodies Identified";
            this.cbShowInactiveAntibodies.AccessibleName = "Show Inactive Antibodies Identified";
            this.cbShowInactiveAntibodies.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.cbShowInactiveAntibodies.Location = new System.Drawing.Point(8, 220);
            this.cbShowInactiveAntibodies.Name = "cbShowInactiveAntibodies";
            this.cbShowInactiveAntibodies.Size = new System.Drawing.Size(592, 20);
            this.cbShowInactiveAntibodies.TabIndex = 17;
            this.cbShowInactiveAntibodies.Text = "Show Inactive Antibodies &Identified";
            this.cbShowInactiveAntibodies.Click += new System.EventHandler(this.cbShowInactiveAntibodies_Click);
            // 
            // lvAntibodies
            // 
            this.lvAntibodies.AccessibleDescription = "Existing Antibody Specificities Identified";
            this.lvAntibodies.AccessibleName = "Existing Antibody Specificities Identified";
            this.lvAntibodies.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.lvAntibodies.CheckBoxes = true;
            this.lvAntibodies.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
            this.columnHeader13,
            this.columnHeader14,
            this.columnHeader15,
            this.columnHeader16,
            this.columnHeader20});
            this.lvAntibodies.HeaderStyle = System.Windows.Forms.ColumnHeaderStyle.Nonclickable;
            this.lvAntibodies.Location = new System.Drawing.Point(8, 20);
            this.lvAntibodies.Name = "lvAntibodies";
            this.lvAntibodies.Size = new System.Drawing.Size(600, 200);
            this.lvAntibodies.TabIndex = 16;
            this.lvAntibodies.UseCompatibleStateImageBehavior = false;
            this.lvAntibodies.View = System.Windows.Forms.View.Details;
            this.lvAntibodies.ItemCheck += new System.Windows.Forms.ItemCheckEventHandler(this.TRs_ItemCheck);
            this.lvAntibodies.ItemChecked += new System.Windows.Forms.ItemCheckedEventHandler(this.lvAntibodies_ItemChecked);
            this.lvAntibodies.SelectedIndexChanged += new System.EventHandler(this.lvAntibodies_SelectedIndexChanged);
            // 
            // columnHeader13
            // 
            this.columnHeader13.Text = "Active";
            this.columnHeader13.Width = 45;
            // 
            // columnHeader14
            // 
            this.columnHeader14.Text = "Antibodies Identified";
            this.columnHeader14.Width = 120;
            // 
            // columnHeader15
            // 
            this.columnHeader15.Text = "Creation Date, User, Division";
            this.columnHeader15.Width = 150;
            // 
            // columnHeader16
            // 
            this.columnHeader16.Text = "Inactivation Date, User, Division";
            this.columnHeader16.Width = 165;
            // 
            // columnHeader20
            // 
            this.columnHeader20.Text = "Inactivation Comment";
            this.columnHeader20.Width = 115;
            // 
            // groupBox2
            // 
            this.groupBox2.AccessibleDescription = "New Antibody Specificity";
            this.groupBox2.AccessibleName = "New Antibody Specificity";
            this.groupBox2.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.groupBox2.Controls.Add(this.btnAntibodyAdd);
            this.groupBox2.Controls.Add(this.cmbAntibody);
            this.groupBox2.Controls.Add(this.lblAntibody);
            this.groupBox2.Location = new System.Drawing.Point(4, 4);
            this.groupBox2.Name = "groupBox2";
            this.groupBox2.Size = new System.Drawing.Size(624, 76);
            this.groupBox2.TabIndex = 0;
            this.groupBox2.TabStop = false;
            this.groupBox2.Text = "New Antibody Specificity";
            // 
            // btnAntibodyAdd
            // 
            this.btnAntibodyAdd.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
            this.btnAntibodyAdd.EnabledButton = false;
            this.btnAntibodyAdd.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.btnAntibodyAdd.Image = ((System.Drawing.Image)(resources.GetObject("btnAntibodyAdd.Image")));
            this.btnAntibodyAdd.Location = new System.Drawing.Point(532, 48);
            this.btnAntibodyAdd.Name = "btnAntibodyAdd";
            this.btnAntibodyAdd.Size = new System.Drawing.Size(75, 23);
            this.btnAntibodyAdd.TabIndex = 15;
            this.btnAntibodyAdd.Click += new System.EventHandler(this.btnAntibodyAdd_Click);
            // 
            // lblAntibody
            // 
            this.lblAntibody.Location = new System.Drawing.Point(8, 20);
            this.lblAntibody.Name = "lblAntibody";
            this.lblAntibody.Size = new System.Drawing.Size(100, 20);
            this.lblAntibody.TabIndex = 0;
            this.lblAntibody.Text = "Antibody*";
            this.lblAntibody.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
            // 
            // patientSelectTool1
            // 
            this.patientSelectTool1.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
            | System.Windows.Forms.AnchorStyles.Left) 
            | System.Windows.Forms.AnchorStyles.Right)));
            this.patientSelectTool1.DisplaySIAndTRs = true;
            this.patientSelectTool1.EnabledBloodAvailButton = false;
            this.patientSelectTool1.EnabledMedicationButton = false;
            this.patientSelectTool1.EnabledRecentOrdersButton = false;
            this.patientSelectTool1.EnabledRecentTransfusionsIssuesButton = false;
            this.patientSelectTool1.EnabledSIAndTRButton = false;
            this.patientSelectTool1.EnabledTransfusionReactionHistoryButton = false;
            this.patientSelectTool1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((byte)(0)));
            this.hlphelpChm.SetHelpKeyword(this.patientSelectTool1, "Patient_Selection.htm");
            this.hlphelpChm.SetHelpNavigator(this.patientSelectTool1, System.Windows.Forms.HelpNavigator.Topic);
            this.patientSelectTool1.Location = new System.Drawing.Point(4, 36);
            this.patientSelectTool1.Name = "patientSelectTool1";
            this.patientSelectTool1.SearchVistaLink = false;
            this.hlphelpChm.SetShowHelp(this.patientSelectTool1, true);
            this.patientSelectTool1.Size = new System.Drawing.Size(684, 400);
            this.patientSelectTool1.TabIndex = 0;
            this.patientSelectTool1.PatientSelected += new System.EventHandler(this.patientSelectTool1_PatientSelected);
            this.patientSelectTool1.PatientDeselected += new System.EventHandler(this.patientSelectTool1_PatientDeselected);
            // 
            // FrmDefineTransfusionReqs
            // 
            this.AcceptButton = this.btnOK;
            this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
            this.CancelButton = this.btnCancel;
            this.ClientSize = new System.Drawing.Size(692, 473);
            this.Controls.Add(this.pnlTransfusionRequirements);
            this.Controls.Add(this.btnCancel);
            this.Controls.Add(this.btnOK);
            this.Controls.Add(this.patientSelectTool1);
            this.hlphelpChm.SetHelpKeyword(this, "Patients_UC_37.htm");
            this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
            this.MinimumSize = new System.Drawing.Size(650, 500);
            this.Name = "FrmDefineTransfusionReqs";
            this.RequiredFieldsLabel = true;
            this.hlphelpChm.SetShowHelp(this, true);
            this.Text = "VBECS - Enter Patient Special Instructions and Transfusion Requirements";
            this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmDefineTransfusionReqs_KeyDownSpeakMessage);
            this.Controls.SetChildIndex(this.patientSelectTool1, 0);
            this.Controls.SetChildIndex(this.btnOK, 0);
            this.Controls.SetChildIndex(this.btnCancel, 0);
            this.Controls.SetChildIndex(this.vbecsLogo1, 0);
            this.Controls.SetChildIndex(this.lblRequiredField, 0);
            this.Controls.SetChildIndex(this.pnlTransfusionRequirements, 0);
            ((System.ComponentModel.ISupportInitialize)(this.errError)).EndInit();
            this.pnlTransfusionRequirements.ResumeLayout(false);
            this.grpImage.ResumeLayout(false);
            ((System.ComponentModel.ISupportInitialize)(this.pictureBox1)).EndInit();
            this.tabTransfusionRequirements.ResumeLayout(false);
            this.pageSpecialInstructions.ResumeLayout(false);
            this.grpNewInstruction.ResumeLayout(false);
            this.grpInstructions.ResumeLayout(false);
            this.pageAntigenNegative.ResumeLayout(false);
            this.grpExistingAntigens.ResumeLayout(false);
            this.grpNewAntigen.ResumeLayout(false);
            this.pageComponentAttribute.ResumeLayout(false);
            this.grpExistingComponentAttributes.ResumeLayout(false);
            this.grpNewComponentAttribute.ResumeLayout(false);
            this.pageAntibodyIDs.ResumeLayout(false);
            this.grpAntibodies.ResumeLayout(false);
            this.groupBox2.ResumeLayout(false);
            this.ResumeLayout(false);
            this.PerformLayout();

		}
		#endregion

		/// <summary>
		/// Private method to initialize UI control properties
		/// </summary>
		private void SetComponentProperties(bool patientSelected)
		{
			this.patientSelectTool1.Visible = true;
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC037.FrmDefineTransfusionReqs());
			//
			//Don't display SIs and TRs on this patient select tool,
			//cos they'll be displayed in the next panel. It was
			//confusing the users!!!
			this.patientSelectTool1.DisplaySIAndTRs = false;
			//
			this.pnlTransfusionRequirements.Visible = false;
			//
			this.patientDisplayPanel1.EnabledSIAndTRButton = false;
			//
			this.btnAddComponentAttribute.Text = "&Add";
			this.btnAddComponentAttribute.EnabledButton = false;
			this.btnAddAntigenScreen.Text = "&Add";
			this.btnAddAntigenScreen.EnabledButton = false;
			this.btnAdd.Text = "&Add";
			this.btnAdd.EnabledButton = false;
			this.btnAntibodyAdd.Text = "&Add";
			this.btnAntibodyAdd.EnabledButton = false;
			this.btnOK.Text = "&OK";
			if (patientSelected == false)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
				this.btnOK.EnabledButton = false;
			}
			//
			this.cmbSpecialRequirement.Interval = 100;
			this.cmbAntigen.Interval = 100;

			// UC38
			this._componentRequirements		= new ArrayList();
			this._antigenNegatives			= new ArrayList();
			this._antibodies				= new ArrayList();

			this._newComponentRequirements	= new ArrayList();
			this._newAntigenNegatives		= new ArrayList();
			this._newAntibodies				= new ArrayList();

			this._inactivatedList			= new ArrayList();

			// UC37
			this._specialInstructions = new ArrayList();
			this._newSpecialInstruction	= new ArrayList();


			// set up Datatables for save
			_dtInsertSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(false);
			_dtUpdateSpecialInstructions = BOL.PatientSpecialInstruction.InitializeSpecialInstructionsTable(true);
			_dtInsertTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(false);
			_dtUpdateTransfusionRequirements = BOL.PatientTransfusionRequirement.InitializeTransfusionRequirementsTable(true);

			this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC038.EnterSpecialInstruction().ResString);
			this.btnAddAntigenScreen.SetToolTip(Common.StrRes.Tooltips.UC038.EnterAntigen().ResString);
			this.btnAddComponentAttribute.SetToolTip(Common.StrRes.Tooltips.UC038.EnterComponentRequirement().ResString);
			this.btnAntibodyAdd.SetToolTip(Common.StrRes.Tooltips.UC038.EnterAntibody().ResString);
		    _removeSI = false;
		    _removeTR = false;
		}


		/// <summary>
		/// This method converts DataTables to objects for easier manipulation
		/// </summary>
		/// <param name="dt"></param>
		/// <param name="specialInstruction"></param>
		private void ConvertToObjects(DataTable dt, bool specialInstruction)
		{
			if (specialInstruction)
			{
				foreach (DataRow dr in dt.Rows)
				{
					BOL.PatientSpecialInstruction sI = new BOL.PatientSpecialInstruction(dr);
					_specialInstructions.Add(sI);
				}
			}
			else
			{
				foreach (DataRow dr in dt.Rows)
				{
					BOL.PatientTransfusionRequirement tR = new BOL.PatientTransfusionRequirement(dr);
					switch (tR.TransfusionRequirementCategoryCode)
					{
						case Common.TransfusionRequirementCategoryCode.ComponentRequirement:
							this._componentRequirements.Add(tR);
							break;
						case Common.TransfusionRequirementCategoryCode.AntigenNegative:
							this._antigenNegatives.Add(tR);
							break;
						case Common.TransfusionRequirementCategoryCode.AntibodyIdentified:
							this._antibodies.Add(tR);
							break;
					}
				}
			}
		}


		/// <summary>
		/// BR_38.01, BR_38.03
		/// </summary>
		private void PopulateComboBoxes()
		{
			System.Data.DataTable dtSIs;
			
			// UC37: Special Instructions 
			this.cmbSpecialInstruction.Items.Add(String.Empty);

			dtSIs = BOL.CannedComment.GetCannedComments(LogonUser.LogonUserDivisionCode, "SI");
			foreach (DataRow dr in dtSIs.Rows) 
			{
				this.cmbSpecialInstruction.Items.Add(dr[Common.VbecsTables.CannedComment.CannedCommentText]);
			}

			// UC38: Transfusion requirements: Components
			// BR_38.01
			this.cmbSpecialRequirement.Items.Add(String.Empty);
		
			this._dtCRs = BOL.BloodComponentClass.GetComponentRequirements();
			foreach (DataRow dr in this._dtCRs.Rows)
			{
				this.cmbSpecialRequirement.Items.Add(dr[Common.VbecsTables.ComponentRequirement.ComponentRequirementText]);
			}


			// UC38: Transfusion requirements: Antigen negatives
			// BR_38.03
			this.cmbAntigen.Items.Add(String.Empty);
			_dtANs = BOL.AntibodyType.GetAntibodyTypeLookupList();
			_dtARs = BOL.AntibodyType.GetCompleteAntibodyTypeList();
				
			int count = 0;
			int counter = 0;
			foreach(DataRow dr in _dtANs.Rows)
			{		
				// Don't want to display everything and don't want duplicates
				if ( System.Enum.IsDefined(typeof(Common.ExcludedAntibodies), (int) dr[Common.VbecsTables.AntibodyType.AntibodyTypeId]) ||
					cmbAntigen.Items.Contains(dr[Common.VbecsTables.AntigenType.AntigenTypeName].ToString()) ||
					(int) dr[Common.VbecsTables.AntibodyType.AntibodyTypeId] == (int) Common.Antibody.AntiD) continue;
				
				this.cmbAntigen.Items.Add(dr[Common.VbecsTables.AntigenType.AntigenTypeName].ToString());
				count++;			
			}

			// UC38: Transfusion requirements: Antibodies
			// BR_38.03
			this.cmbAntibody.Items.Add(String.Empty);
			counter = 0;

	
			ArrayList alreadyAdded = new ArrayList();
			foreach(DataRow dr in _dtARs.Rows)
			{
				if ( System.Enum.IsDefined(typeof(Common.ExcludedAntigens), (int) dr[Common.VbecsTables.AntibodyType.AntibodyTypeId])) continue;
				int antibodyId = (int) dr[Common.VbecsTables.AntibodyType.AntibodyTypeId];
				
				if (!alreadyAdded.Contains(antibodyId))
				{
					counter++;
					this.cmbAntibody.Items.Add(dr[Common.VbecsTables.AntibodyType.AntibodyTypeName]);
					alreadyAdded.Add(antibodyId);
				}
			}
		}


		#region UC37Methods

		/// <summary>
		/// BR_37.02, BR_37.04, BR_37.05
		/// </summary>
		private void LoadListView37()
		{
			ArrayList inactiveSIs = new ArrayList();
			_loading = true;

			// This has to be done to prevent strange display problems.
			ListView lvInstructions = new ListView();

			this.lvInstructions.Items.Clear();
			this.lvInstructions.Refresh();

			for(int k=0; k<_specialInstructions.Count; k++)
			{
				BOL.PatientSpecialInstruction pSI = (BOL.PatientSpecialInstruction) this._specialInstructions[k];

				// For maintenance, only display the Instructions for this division!
				// In the ListView, inactive SIs should be displayed after the others.  Save them here and 
				// add them to the ListView below.
				if (pSI.RecordStatusCode != Common.RecordStatusCode.Active && pSI.RecordStatusCode != Common.RecordStatusCode.Converted) 
				{
					inactiveSIs.Add(pSI);
					continue;
				}
				else
				{
					// BR_37.02
					ListViewItem lviComment = new ListViewItem();

					// If the comment is new, make it a different color to differentiate
					if (this._newSpecialInstruction != null && this._newSpecialInstruction.Contains(pSI))
					{
						lviComment.ForeColor = Color.Blue;
					}
					lviComment.Tag = pSI;

					lviComment.Checked = true;
					lviComment.SubItems.Add(pSI.PatientSpecialInstructions);
					// BR_37.05
					if (pSI.VistaConversionIndicator != true)
					{	
						try
						{
							lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.CreateDate) + " by " + new BOL.VbecsUser( pSI.CreateUser ).UserName);
						}
						catch(Exception)
						{
							lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.CreateDate) + " by " + pSI.CreateUser);
						}
					}
					else
					{
						lviComment.SubItems.Add("VistA converted");
					}
					
					this.lvInstructions.Items.Add(lviComment);
				}
			}
			
			// BR_37.04: Display inactive SIs now
			if (_showInactiveSIs == true && inactiveSIs.Count > 0)
			{
				for(int k=0; k<inactiveSIs.Count; k++)
				{
					BOL.PatientSpecialInstruction pSI = (BOL.PatientSpecialInstruction) inactiveSIs[k];
					ListViewItem lviComment = new ListViewItem();
					lviComment.ForeColor = Color.Red;
					lviComment.Tag = pSI;

					lviComment.Checked = false;
					lviComment.SubItems.Add(pSI.PatientSpecialInstructions);
					if (pSI.VistaConversionIndicator != true)
					{
						try
						{
							lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.CreateDate) + " by " + new BOL.VbecsUser( pSI.CreateUser ).UserName);
						}
						catch (Exception)
						{
							lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.CreateDate) + " by " + pSI.CreateUser);
						}
					}
					else
					{
						lviComment.SubItems.Add("Vista converted");
					}
					try
					{
						lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.InactivateDate) + " by " + new BOL.VbecsUser( pSI.InactivateUser ).UserName);
					}
					catch (Exception)
					{
						lviComment.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pSI.InactivateDate) + " by " + pSI.InactivateUser);
					}

					lviComment.SubItems.Add(pSI.InactivationComment);

					this.lvInstructions.Items.Add(lviComment);
				}
			}
			controls.VbecsFunction.SetColumnWidths(this.lvInstructions);
			this.lvInstructions.Refresh();
			_loading = false;
		}

		#endregion


		#region UC38Methods

		/// <summary>
		/// BR_38.08, BR_38.11
		/// </summary>
		/// <param name="transfusionRequirementType"></param>
		private void LoadListView38(Common.TransfusionRequirementCategoryCode transfusionRequirementType)
		{
			ArrayList inactiveTRs = new ArrayList();
			_loading = true;

			//figure out which ListView to operate on
			ListView lvTransfusionRequirements = new ListView();
			ArrayList transfusionRequirements = new ArrayList();
			ArrayList newTransfusionRequirements = new ArrayList();
			bool showInactiveTRs = false;
			switch (transfusionRequirementType)
			{
				case Common.TransfusionRequirementCategoryCode.ComponentRequirement:
					lvTransfusionRequirements = this.lvComponentAttributes;
					transfusionRequirements = this._componentRequirements;
					newTransfusionRequirements = this._newComponentRequirements;
					showInactiveTRs = this._showInactiveCRs;
					break;
				case Common.TransfusionRequirementCategoryCode.AntigenNegative:
					lvTransfusionRequirements = this.lvAntigenNegative;
					transfusionRequirements = this._antigenNegatives;
					newTransfusionRequirements = this._newAntigenNegatives;
					showInactiveTRs = this._showInactiveANs;
					break;
				case Common.TransfusionRequirementCategoryCode.AntibodyIdentified:
					lvTransfusionRequirements = this.lvAntibodies;
					transfusionRequirements = this._antibodies;
					newTransfusionRequirements = this._newAntibodies;
					showInactiveTRs = this._showInactiveAIs;
					break;
			}

			lvTransfusionRequirements.Items.Clear();

			for(int k=0; k<transfusionRequirements.Count; k++)
			{
				BOL.PatientTransfusionRequirement pTR = (BOL.PatientTransfusionRequirement) transfusionRequirements[k];

				// In the ListView, inactive SIs should be displayed after the others.  Save them here and 
				// add them to the ListView after the active ones are added.  This should be replaced by a 
				// sorting algorithm (implement Icomparable?).
				if (pTR.RecordStatusCode != Common.RecordStatusCode.Active  && pTR.RecordStatusCode != Common.RecordStatusCode.Converted) 
				{
					inactiveTRs.Add(pTR);
					continue;
				}
				else
				{
					ListViewItem lviPatientRequirement = new ListViewItem();

					// If the comment is new, make it a different color to differentiate
					if (newTransfusionRequirements != null && newTransfusionRequirements.Contains(pTR))
					{
						lviPatientRequirement.ForeColor = Color.Blue;
					}
					lviPatientRequirement.Tag = pTR;

					lviPatientRequirement.Checked = true;
					lviPatientRequirement.SubItems.Add(pTR.TransfusionRequirement);
					if (pTR.VistaConversionIndicator != true)
					{
						// BR_38.11						
						try
						{
							lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.CreateDate) + " by " + new BOL.VbecsUser( pTR.CreateUser ).UserName + ", Division " + pTR.CreateDivisionCode);
						}
						catch (Exception)
						{
							lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.CreateDate) + " by " + pTR.CreateUser + ", Division " + pTR.CreateDivisionCode);
						}
					}
					else
					{
						lviPatientRequirement.SubItems.Add("Vista converted");
					}

					lvTransfusionRequirements.Items.Add(lviPatientRequirement);
				}
			}
			
			// Display inactive SIs now
			if (showInactiveTRs == true && inactiveTRs.Count > 0)
			{
				for(int k=0; k<inactiveTRs.Count; k++)
				{
					BOL.PatientTransfusionRequirement pTR = (BOL.PatientTransfusionRequirement) inactiveTRs[k];
					ListViewItem lviPatientRequirement = new ListViewItem();
					lviPatientRequirement.ForeColor = Color.Red;
					lviPatientRequirement.Tag = pTR;

					lviPatientRequirement.Checked = false;
					lviPatientRequirement.SubItems.Add(pTR.TransfusionRequirement);
					if (pTR.VistaConversionIndicator != true)
					{
						try
						{
							lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.CreateDate) + " by " + new BOL.VbecsUser( pTR.CreateUser ).UserName + ", Division " + pTR.CreateDivisionCode);
						}
						catch (Exception)
						{
							lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.CreateDate) + " by " + pTR.CreateUser + ", Division " + pTR.CreateDivisionCode);
						}
					}
					else
					{
						lviPatientRequirement.SubItems.Add("Vista converted");
					}
					
					try
					{
						lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.InactivateDate) + " by " + new BOL.VbecsUser( pTR.InactivateUser ).UserName + ", Division " + pTR.InactivateDivisionCode);
					}
					catch (Exception)
					{
						lviPatientRequirement.SubItems.Add(Common.VBECSDateTime.FormatDateTimeString(pTR.InactivateDate) + " by " + pTR.InactivateUser + ", Division " + pTR.InactivateDivisionCode);
					}

					lviPatientRequirement.SubItems.Add(pTR.InactivationComment);

					lvTransfusionRequirements.Items.Add(lviPatientRequirement);
				}
			}
			controls.VbecsFunction.SetColumnWidths(lvTransfusionRequirements);
			lvTransfusionRequirements.Refresh();
			_loading = false;
		}

		
		private void LoadDataTableForTRs(ArrayList allTRs, ArrayList newTRs, Common.TransfusionRequirementCategoryCode code)
		{
			for (int i=0; i<allTRs.Count; i++)
			{
				BOL.PatientTransfusionRequirement pTR =  (BOL.PatientTransfusionRequirement) allTRs[i];

					
				// if new
				if (newTRs != null && newTRs.Contains(pTR))
				{
					DataRow dr = _dtInsertTransfusionRequirements.NewRow();

					dr[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = System.Guid.NewGuid();
					if (_patient != null)
					{
						dr[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = _patient.PatientGuid;
					}
					else
					{
						dr[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = patientSelectTool1.SelectedPatient.PatientGuid;
					}
					dr[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementText] = pTR.TransfusionRequirement;
					dr[Common.VbecsTables.PatientTransfusionRequirement.TransfusionRequirementCategoryCode] = Common.Utility.GetTransfusionCategoryCodeFromEnum( pTR.TransfusionRequirementCategoryCode );
					dr[Common.VbecsTables.PatientTransfusionRequirement.CreateDate] = pTR.CreateDate;
					dr[Common.VbecsTables.PatientTransfusionRequirement.CreateUser] = pTR.CreateUser;
					dr[Common.VbecsTables.PatientTransfusionRequirement.CreateDivisionCode] = pTR.CreateDivisionCode;
					dr[Common.VbecsTables.PatientTransfusionRequirement.VistaConversionIndicator] = false;
					if (code == Common.TransfusionRequirementCategoryCode.AntibodyIdentified)
					{
						dr[Common.VbecsTables.PatientTransfusionRequirement.AntibodyTypeId] = pTR.AntibodyTypeId;
					}
					else if (code == Common.TransfusionRequirementCategoryCode.ComponentRequirement)
					{
						dr[Common.VbecsTables.PatientTransfusionRequirement.ComponentRequirementId] = pTR.ComponentRequirementId;
					}
					else if (code == Common.TransfusionRequirementCategoryCode.AntigenNegative)
					{
						dr[Common.VbecsTables.PatientTransfusionRequirement.AntigenTypeId] = pTR.AntigenTypeId;
					}
					dr[Common.VbecsTables.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
					dr[Common.VbecsTables.PatientTransfusionRequirement.LastUpdateUser] = ThisUser.UserNTLoginID;
					dr[Common.VbecsTables.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
					_dtInsertTransfusionRequirements.Rows.Add(dr);
				}
				else
				{
					if (_inactivatedList.Contains(pTR.TransfusionRequirementGuid))
					{
						DataRow dr = _dtUpdateTransfusionRequirements.NewRow();

						dr[Common.VbecsTables.PatientTransfusionRequirement.PatientTransfusionRequirementGuid] = pTR.TransfusionRequirementGuid;
						dr[Common.VbecsTables.PatientTransfusionRequirement.InactivationComment] = pTR.InactivationComment;
						dr[Common.VbecsTables.PatientTransfusionRequirement.InactivateDate] = pTR.InactivateDate;
						dr[Common.VbecsTables.PatientTransfusionRequirement.InactivateUser] = pTR.InactivateUser;
						dr[Common.VbecsTables.PatientTransfusionRequirement.InactivateDivisionCode] = pTR.InactivateDivisionCode;
						dr[Common.VbecsTables.PatientTransfusionRequirement.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum( pTR.RecordStatusCode );
						dr[Common.VbecsTables.PatientTransfusionRequirement.LastUpdateUser] = ThisUser.UserNTLoginID;
						dr[Common.VbecsTables.PatientTransfusionRequirement.RowVersion] = pTR.RowVersion;
						dr[Common.VbecsTables.PatientTransfusion.DivisionCode] = Common.LogonUser.LogonUserDivisionCode;
						_dtUpdateTransfusionRequirements.Rows.Add(dr);
					}
				}				
			}
		}

		#endregion


		private bool IsDuplicate(BOL.PatientSpecialInstruction pSI)
		{
			bool match = false;
			foreach (BOL.PatientSpecialInstruction pSIns in  this._newSpecialInstruction)
			{
				if (pSI.PatientSpecialInstructions.Trim().Equals(pSIns.PatientSpecialInstructions.Trim()))
				{
					match = true;
					break;
				}
			}
			return match;
		}

		private bool IsDuplicate(BOL.PatientTransfusionRequirement pTR, short type)
		{
			bool match = false;
			if (type == 1)
			{
				foreach (BOL.PatientTransfusionRequirement pTReq in  _newAntigenNegatives)
				{
					if (pTR.TransfusionRequirement.Equals(pTReq.TransfusionRequirement))
					{
						match = true;
						break;
					}
				}
			}
			if (type == 2)
			{
				foreach (BOL.PatientTransfusionRequirement pTReq in  this._newComponentRequirements)
				{
					if (pTR.TransfusionRequirement.Equals(pTReq.TransfusionRequirement))
					{
						match = true;
						break;
					}
				}
			}
			if (type == 3)
			{
				foreach (BOL.PatientTransfusionRequirement pTReq in  this._newAntibodies)
				{
					if (pTR.TransfusionRequirement.Equals(pTReq.TransfusionRequirement))
					{
						match = true;
						break;
					}
				}
			}
			return match;
		}

		#endregion


		#region events

		// enable the OK button when a patient has been selected.
		private void patientSelectTool1_PatientSelected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = true;	
			this.btnOK.SetToolTip(string.Empty);
		}

		// disable the OK button when a patient has been deselected.
		private void patientSelectTool1_PatientDeselected(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = false;
			this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.SelectPatient().ResString);
		}	

		private void btnOK_Click(object sender, System.EventArgs e)
		{	
			if (this.patientSelectTool1.Visible)
			{
				//It may look like we're locking the PatientGuid, but inside SetLocks is functionality
				//that essentially just locks UC37/38 for this patient
				if (!this.LockUseCase(this.patientSelectTool1.SelectedPatient.PatientGuid))
				{
					return;
				}
				this.vbecsLogo1.Title = "Enter Patient Special Instructions and Transfusion Requirements";
				this.patientSelectTool1.Visible = false;
				this.pnlTransfusionRequirements.Visible = true;
				this.tabTransfusionRequirements.Visible = true;
				this.PopulateComboBoxes();
				// UC37 - initialize ArrayLists
				this.ConvertToObjects(this.patientSelectTool1.SelectedPatient.SpecialInstructions, true);
				// UC38 - initialize ArrayLists
				this.ConvertToObjects(this.patientSelectTool1.SelectedPatient.TransfusionRequirements, false);
			
				this.patientDisplayPanel1.Patient = this.patientSelectTool1.SelectedPatient;
				this.patientDisplayPanel1.PatientInfoToolbar.EnabledSIAndTRButton = false;
				this.LoadListView37();
				// Load combo boxes for UC38
				this.LoadListView38(Common.TransfusionRequirementCategoryCode.ComponentRequirement);
				this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntigenNegative);
				this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntibodyIdentified);

				// **** 508 Compliance ***
				this.btnOK.EnabledButton = false; 
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.NoChangesToSave().ResString);  
			}
			else
			{
				DialogResult _saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.OKToSave("Special Instruction and Transfusion Requirement"));
				if (_saveResult == DialogResult.Yes)
				{
					// save the changes
					for (int i=0; i<_specialInstructions.Count; i++)
					{					
						BOL.PatientSpecialInstruction pSI =  (BOL.PatientSpecialInstruction) _specialInstructions[i];
									
						// if new
						if (_newSpecialInstruction.Contains(pSI))
						{
							DataRow dr = _dtInsertSpecialInstructions.NewRow();

							dr[Common.VbecsTables.PatientSpecialInstruction.PatientSpecialInstructionGuid] = System.Guid.NewGuid();
							if (_patient != null)
							{
								dr[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = _patient.PatientGuid;
							}
							else
							{
								dr[Common.VbecsTables.PatientSpecialInstruction.PatientGuid] = this.patientSelectTool1.SelectedPatient.PatientGuid;
							}
							dr[Common.VbecsTables.PatientSpecialInstruction.PatientSpecialInstructions] = pSI.PatientSpecialInstructions;
							dr[Common.VbecsTables.PatientSpecialInstruction.CreateDate] = pSI.CreateDate;
							dr[Common.VbecsTables.PatientSpecialInstruction.CreateUser] = pSI.CreateUser;
							dr[Common.VbecsTables.PatientSpecialInstruction.VistaConversionIndicator] = false;
							dr[Common.VbecsTables.PatientSpecialInstruction.DivisionCode] = LogonUser.LogonUserDivisionCode;
							dr[Common.VbecsTables.PatientSpecialInstruction.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum(Common.RecordStatusCode.Active);
							dr[Common.VbecsTables.PatientSpecialInstruction.LastUpdateUser] = ThisUser.UserNTLoginID;
							_dtInsertSpecialInstructions.Rows.Add(dr);
						}
						else
						{
							DataRow dr = this._dtUpdateSpecialInstructions.NewRow();

							if (_inactivatedList.Contains(pSI.PatientSpecialInstructionGuid))
							{
								dr[Common.VbecsTables.PatientSpecialInstruction.PatientSpecialInstructionGuid] = pSI.PatientSpecialInstructionGuid;
								dr[Common.VbecsTables.PatientSpecialInstruction.InactivationComment] = pSI.InactivationComment;
								dr[Common.VbecsTables.PatientSpecialInstruction.InactivateDate] = pSI.InactivateDate;
								dr[Common.VbecsTables.PatientSpecialInstruction.InactivateUser] = pSI.InactivateUser;
								dr[Common.VbecsTables.PatientSpecialInstruction.RecordStatusCode] = Common.Utility.GetRecordStatusCodeCharFromEnum( pSI.RecordStatusCode );
								dr[Common.VbecsTables.PatientSpecialInstruction.LastUpdateUser] = ThisUser.UserNTLoginID;
								dr[Common.VbecsTables.PatientSpecialInstruction.DivisionCode]	= LogonUser.LogonUserDivisionCode;
								dr[Common.VbecsTables.PatientSpecialInstruction.RowVersion] = pSI.RowVersion;
								_dtUpdateSpecialInstructions.Rows.Add(dr);
							}
						}				
					}

					this.LoadDataTableForTRs(_componentRequirements, _newComponentRequirements, Common.TransfusionRequirementCategoryCode.ComponentRequirement);
					this.LoadDataTableForTRs(_antigenNegatives, _newAntigenNegatives, Common.TransfusionRequirementCategoryCode.AntigenNegative);
					this.LoadDataTableForTRs(_antibodies, _newAntibodies, Common.TransfusionRequirementCategoryCode.AntibodyIdentified);

					try
					{
						BOL.Patient.SaveSIsAndTRs(_dtInsertSpecialInstructions, 
							_dtUpdateSpecialInstructions,
							_dtInsertTransfusionRequirements, 
							_dtUpdateTransfusionRequirements,
							Common.UpdateFunction.UC038FrmDefineTransfusionReqs);
				
					}
					catch(RowVersionException)
					{
						this.btnOK.RowVersionException = true;		//CR2077
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataWasNotSavedBecauseOfRowversionViolation());
					}
					//Successful update, page not dirty, close window.
					this.IsDirty=false;
					this.Close();
				}
			}
		}


		#region UC37Events

		/// <summary>
		/// Add SI
		/// BR_37.01, BR_37.09
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAdd_Click(object sender, System.EventArgs e)
		{
			if (BOL.PatientSpecialInstruction.SITextMatchesTR(cmbSpecialInstruction.Text.Trim()))
			{
				string message = " \"" + cmbSpecialInstruction.Text.Trim() + " \" appears to be or is similar to a transfusion requirement.  Do you really want to add it as an SI?";
				DialogResult result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.Dynamic(message));
				if (result == DialogResult.No)
				{
					this.cmbSpecialInstruction.Text = String.Empty;
				}
				// Add the item to the ArrayList and the repopulate the list view.
				else
				{
					// First, create a new SpecialTestingInstruction
					BOL.PatientSpecialInstruction pSI = new BOL.PatientSpecialInstruction(this.patientSelectTool1.SelectedPatient, this.cmbSpecialInstruction.Text, LogonUser.LogonUserDivisionCode);
			
					if (IsDuplicate(pSI))
					{
						GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DuplicateTransfusionRequirement());
					}
					else
					{
						this._specialInstructions.Insert(0, pSI);
						// For purposes of inactivate/deletion, we must keep track of special instructions that were newly added.
						// If an existing SI is inactivated, the appropriate save must take place with comments.  However, if
						// a newly added SI is inactivated, it can simply be deleted since it hasn't been saved to the database.
						this._newSpecialInstruction.Add(pSI);
						LoadListView37();	
						//Update occured, form is dirty.
						this.IsDirty=true;
					}
				}
			}	
			else
			{
				// Add the item to the ArrayList and the repopulate the list view.
			
				// First, create a new SpecialTestingInstruction
				BOL.PatientSpecialInstruction pSI = new BOL.PatientSpecialInstruction(this.patientSelectTool1.SelectedPatient, this.cmbSpecialInstruction.Text, LogonUser.LogonUserDivisionCode);
			
				if (IsDuplicate(pSI))
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DuplicateTransfusionRequirement());
				}
				else
				{
					this._specialInstructions.Insert(0, pSI);
					// For purposes of inactivate/deletion, we must keep track of special instructions that were newly added.
					// If an existing SI is inactivated, the appropriate save must take place with comments.  However, if
					// a newly added SI is inactivated, it can simply be deleted since it hasn't been saved to the database.
					this._newSpecialInstruction.Add(pSI);
					LoadListView37();	
					this.IsDirty=true;
				}	
			}
			//
			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}

		private void cmbSpecialInstruction_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbSpecialInstruction.Text.Trim().Length > 0)
			{
				this.btnAdd.EnabledButton = true;
				this.btnAdd.SetToolTip(string.Empty);
			}
			else
			{
				this.btnAdd.EnabledButton = false;
				this.btnAdd.SetToolTip(Common.StrRes.Tooltips.UC038.EnterSpecialInstruction().ResString);
			}
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// BR_37.03, BR_37.04, BR_37.06
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void lvInstructions_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			if (_loading == false)
			{
				ListViewItem lVI = lvInstructions.Items[e.Index];
				BOL.PatientSpecialInstruction pSI = (BOL.PatientSpecialInstruction) lVI.Tag;

				// If this in an inactive SI, don't let them do anything
				if (pSI.RecordStatusCode != Common.RecordStatusCode.Active && pSI.RecordStatusCode != Common.RecordStatusCode.Converted)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ReactivationError("Special Instruction"));
					e.NewValue = CheckState.Unchecked;
				}

				// BR_37.01 - Inactivate SI
				if ((e.NewValue == System.Windows.Forms.CheckState.Unchecked) && (pSI.RecordStatusCode == Common.RecordStatusCode.Active || pSI.RecordStatusCode == Common.RecordStatusCode.Converted) )
				{
					// If user is trying to inactivate a newly entered SI, just delete it (no need to go through normal
					// in activation flow since it hasn't been saved yet).
					if (this._newSpecialInstruction != null && _newSpecialInstruction.Contains(pSI))
					{
						this.IsDirty=true;
					    _removeSI = true;
						this._newSpecialInstruction.Remove(pSI);
						this._specialInstructions.Remove(pSI);
					}
					// Otherwise, let the user enter a comment and inactivate.
					else
					{
						// BR_37.04 May only inactivate in own division
						if (!pSI.VistaConversionIndicator && pSI.DivisionCode.Trim() != Common.LogonUser.LogonUserDivisionCode.Trim())
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC038.CannotInactivateInOtherDivision());
							e.NewValue = CheckState.Checked;
							return;
						}

						// BR_37.04, BR_37.06
						if ( !pSI.VistaConversionIndicator || (pSI.VistaConversionIndicator && ThisUser.IsAuthorizedForFunction( Common.FunctionCode.InactivateTransfusionRequirement ) ) )
						{
							//Launch the window so user can enter comments
							DlgOverrideComment dlgSIC = new DlgOverrideComment("Confirm Inactivation", "Enter a comment before inactivating.", "SX");
							
                            dlgSIC.ShowDialogFromLockedParent(this, false);

							// BR_37.01, BR_37.08
                            if (dlgSIC.DialogResult == DialogResult.OK)
							{
								this.IsDirty=true;
							    _removeSI = true;
								_inactivatedList.Add(pSI.PatientSpecialInstructionGuid);
								pSI.InactivationComment = dlgSIC.Comment;
								pSI.RecordStatusCode = Common.RecordStatusCode.Inactive;
								pSI.InactivateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
								pSI.InactivateUser = Common.LogonUser.LogonUserName;
							}
							else
							{
								e.NewValue = CheckState.Checked;
							}
						}
						else
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges(
								"inactivate a Special Instruction from VistA conversion."));
							e.NewValue = CheckState.Checked;

						}
					}
				}
			}
			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}

		private void cbShowInactive_Click(object sender, System.EventArgs e)
		{
			_showInactiveSIs = cbShowInactive.Checked;
			this.LoadListView37();
		}

		#endregion


		#region UC38Events

		/// <summary>
		/// BR_38.09: AN Reqs may be inactivated.
		/// BR_38.12
		/// BR_38.14
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void TRs_ItemCheck(object sender, System.Windows.Forms.ItemCheckEventArgs e)
		{
			Common.TransfusionRequirementCategoryCode tType = Common.TransfusionRequirementCategoryCode.Unknown;
			if (_loading == false)
			{
				ListView lvTRs = (System.Windows.Forms.ListView) sender;

				if (lvTRs == this.lvComponentAttributes)
				{
					tType = Common.TransfusionRequirementCategoryCode.ComponentRequirement;
				}
				else if (lvTRs == this.lvAntigenNegative)
				{
					tType = Common.TransfusionRequirementCategoryCode.AntigenNegative;
				}
				else
				{
					tType = Common.TransfusionRequirementCategoryCode.AntibodyIdentified;
				}


				ListViewItem lVI = lvTRs.Items[e.Index];
				BOL.PatientTransfusionRequirement pTR = (BOL.PatientTransfusionRequirement) lVI.Tag;

				// If this in an inactive TR, don't let them do anything
				if (pTR.RecordStatusCode != Common.RecordStatusCode.Active && pTR.RecordStatusCode != Common.RecordStatusCode.Converted)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ReactivationError("Transfusion Requirement"));
					e.NewValue = CheckState.Unchecked;
					return;
				}

				// Inactivate
				if (e.NewValue == System.Windows.Forms.CheckState.Unchecked &&
					(pTR.RecordStatusCode == Common.RecordStatusCode.Active || 
					pTR.RecordStatusCode == Common.RecordStatusCode.Converted))
				{
					this.IsDirty=true;
					// If user is trying to inactivate a NEWLY entered SI, remove it.
					if (this._newComponentRequirements.Contains(pTR) || this._newAntigenNegatives.Contains(pTR)
						|| this._newAntibodies.Contains(pTR))
					{
					    _removeTR = true;
						switch (tType)
						{
							case Common.TransfusionRequirementCategoryCode.ComponentRequirement:
								this._newComponentRequirements.Remove(pTR);
								this._componentRequirements.Remove(pTR);
								break;
							case Common.TransfusionRequirementCategoryCode.AntigenNegative:
								this._newAntigenNegatives.Remove(pTR);
								this._antigenNegatives.Remove(pTR);
								break;
							case Common.TransfusionRequirementCategoryCode.AntibodyIdentified:
								this._newAntibodies.Remove(pTR);
								this._antibodies.Remove(pTR);
								break;
						}
					}
					// Otherwise, let the user enter a comment and inactivate.
					else
					{
						if (pTR.SpecimenTestGuid != Guid.Empty)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.UC038.CannotInactivateTestResult());
							e.NewValue = CheckState.Checked;
							return;
						}

						// BR_38.12
						if (  ThisUser.IsAuthorizedForFunction( Common.FunctionCode.InactivateTransfusionRequirement ) )
						{
							//Launch the window to put comments in
							DlgOverrideComment dlgSIC = new DlgOverrideComment("Confirm Inactivation", "Enter a comment before inactivating.", "TX");
							dlgSIC.ShowDialogFromLockedParent(this, false);

                            // If OK button pressed
							// BR_37.01
                            if (dlgSIC.DialogResult == DialogResult.OK)
                            {
                                _removeTR = true;
								_inactivatedList.Add(pTR.TransfusionRequirementGuid);
								pTR.InactivationComment = dlgSIC.Comment;
								pTR.RecordStatusCode = Common.RecordStatusCode.Inactive;
								pTR.InactivateDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
								pTR.InactivateUser = Common.LogonUser.LogonUserName;
								pTR.InactivateDivisionCode = LogonUser.LogonUserDivisionCode;
							}
							else
							{
								e.NewValue = CheckState.Checked;
							}
						}
						else
						{
							e.NewValue = CheckState.Checked;
							GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.InsufficientSecurityPrivileges(
								"inactivate a Transfusion Requirement."));
						}
					}
				}
			}
			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}


		private void tabTransfusionRequirements_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			switch (this.tabTransfusionRequirements.SelectedIndex)
			{
				case 0:
					this.vbecsLogo1.Title = "Enter Special Instructions";
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC037.FrmDefineTransfusionReqs());
					break;
				case 1:
					this.vbecsLogo1.Title = "Enter Antigen Negative Requirements";
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC038.FrmDefineTransfusionReqs());
					break;
				case 2:
					this.vbecsLogo1.Title = "Enter Component Requirements";
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC038.FrmDefineTransfusionReqs());
					break;
				case 3:
					this.vbecsLogo1.Title = "Enter Antibody Requirements";
					this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC038.FrmDefineTransfusionReqs());
					break;
				// error condition
				default:
					this.vbecsLogo1.Title = "Enter Special Instructions & Transfusion Requirements";
					break;
			}
		}

		
		#region ComponentRequirements

		// add to ListView
		/// <summary>
		/// BR_38.06, BR_38.07
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddComponentAttribute_Click(object sender, System.EventArgs e)
		{
			// Add the item to the ArrayList and the repopulate the list view.
			// First, create a new SpecialTestingInstruction
			// BR_38.07
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(this.patientSelectTool1.SelectedPatient, this.cmbSpecialRequirement.Text, Common.TransfusionRequirementCategoryCode.ComponentRequirement,  LogonUser.LogonUserDivisionCode);
			
			// Component requirement ID
			string filter = Common.VbecsTables.ComponentRequirement.ComponentRequirementText + " = '" + this.cmbSpecialRequirement.Text + "'";
			DataRow[] dataRows = this._dtCRs.Select(filter);
				
			// There should be only one DataRow returned
			pTR.ComponentRequirementId = (byte) dataRows[0][Common.VbecsTables.ComponentRequirement.ComponentRequirementId];	

			if (IsDuplicate(pTR, COMPONENT)) 
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DuplicateTransfusionRequirement());
			}
			else
			{
				this._componentRequirements.Insert(0, pTR);
				// For purposes of inactivate/deletion, we must keep track of special instructions that were newly added.
				// If an existing SI is inactivated, the appropriate save must take place with comments.  However, if
				// a newly added SI is inactivated, it can simply be saved.
				this._newComponentRequirements.Add(pTR);
				this.IsDirty=true;
			}

			LoadListView38(Common.TransfusionRequirementCategoryCode.ComponentRequirement);

			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}

		private void cmbSpecialRequirement_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbSpecialRequirement.SelectedIndex > 0)
			{
				this.btnAddComponentAttribute.EnabledButton = true;
				this.btnAddComponentAttribute.SetToolTip(string.Empty);
			}
			else
			{
				this.btnAddComponentAttribute.EnabledButton = false;
				this.btnAddComponentAttribute.SetToolTip(Common.StrRes.Tooltips.UC038.EnterComponentRequirement().ResString);
			}
		}

		private void cbShowInactiveComponentRequirements_Click(object sender, System.EventArgs e)
		{
			this._showInactiveCRs = this.cbShowInactiveComponentRequirements.Checked;
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.ComponentRequirement);
		}
		
		#endregion



		#region AntigenNegative

		/// <summary>
		/// BR_38.04, BR_38.06, BR_38.07
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAddAntigenScreen_Click(object sender, System.EventArgs e)
		{
			bool duplicate;

			// BR_38.04, BR_38.07
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(this.patientSelectTool1.SelectedPatient, this.cmbAntigen.Text, Common.TransfusionRequirementCategoryCode.AntigenNegative,  LogonUser.LogonUserDivisionCode);
			
			// Antibody ID
			string filter = Common.VbecsTables.AntigenType.AntigenTypeName + " = '" + this.cmbAntigen.Text + "'";
			DataRow[] dtRows = _dtANs.Select(filter);

			int i = 0;
			for (i=0; i < dtRows.Length; i++)
			{
				if (cmbAntigen.Text == dtRows[i][Common.VbecsTables.AntigenType.AntigenTypeName].ToString()) break;
			}
				
			pTR.AntigenTypeId = (int) dtRows[i][Common.VbecsTables.PatientTransfusionRequirement.AntigenTypeId];		

			duplicate = IsDuplicate(pTR, ANTIGEN);

			if (duplicate) 
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DuplicateTransfusionRequirement());
			}
			else
			{
				_antigenNegatives.Insert(0, pTR);
				_newAntigenNegatives.Add(pTR);
				this.IsDirty=true;
			}

			LoadListView38(Common.TransfusionRequirementCategoryCode.AntigenNegative);

			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}

		private void cmbAntigen_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbAntigen.SelectedIndex > 0 && cmbAntigen.Text.Trim().Length > 0)
			{
				this.btnAddAntigenScreen.EnabledButton = true;
				this.btnAddAntigenScreen.SetToolTip(string.Empty);
			}
			else
			{
				this.btnAddAntigenScreen.EnabledButton = false;
				this.btnAddAntigenScreen.SetToolTip(Common.StrRes.Tooltips.UC038.EnterAntigen().ResString);
			}
		}

		private void cbShowInactiveAntigens_Click(object sender, System.EventArgs e)
		{
			_showInactiveANs = this.cbShowInactiveAntigens.Checked;
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntigenNegative);
		}

		#endregion



        #region Antibodies

		/// <summary>
		/// BR_38.06, BR_38.07
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnAntibodyAdd_Click(object sender, System.EventArgs e)
		{
			bool duplicate;
			// BR_38.07
			BOL.PatientTransfusionRequirement pTR = new BOL.PatientTransfusionRequirement(this.patientSelectTool1.SelectedPatient, this.cmbAntibody.Text, Common.TransfusionRequirementCategoryCode.AntibodyIdentified,  LogonUser.LogonUserDivisionCode);
			
			// Antibody ID
			string filter = Common.VbecsTables.AntibodyType.AntibodyTypeName + " = '" + this.cmbAntibody.Text + "'";
			DataRow[] dataRows = _dtARs.Select(filter);

			if (dataRows.Length==1)
			{
				pTR.AntibodyTypeId = (int) dataRows[0][Common.VbecsTables.AntibodyType.AntibodyTypeId];
			}
			else if (dataRows.Length>1)
			{
				foreach (DataRow dr in dataRows)
				{
					string antibodyTypeName = dr[Common.VbecsTables.AntibodyType.AntibodyTypeName].ToString();
					if (antibodyTypeName==this.cmbAntibody.Text)
					{
							pTR.AntibodyTypeId = (int) dr[Common.VbecsTables.AntibodyType.AntibodyTypeId];
					}
				}
			}
			else
			{
				throw new BOL.BusinessObjectException("Antibody ID not found");
			}

			duplicate = IsDuplicate(pTR, ANTIBODY);
			if (duplicate) 
			{
				GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DuplicateTransfusionRequirement());
			}
			else
			{
				this._antibodies.Insert(0, pTR);
				this._newAntibodies.Add(pTR);
				this.IsDirty=true;
			}
			
			LoadListView38(Common.TransfusionRequirementCategoryCode.AntibodyIdentified);

			// **** 508 Compliance ***
			if (this.IsDirty)
			{
				btnOK.EnabledButton = true;
				this.btnOK.SetToolTip(string.Empty);  
			}
		}

		private void cmbAntibody_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			if (cmbAntibody.SelectedIndex > 0)
			{
				this.btnAntibodyAdd.EnabledButton = true;
				this.btnAntibodyAdd.SetToolTip(string.Empty);
			}
			else
			{
				this.btnAntibodyAdd.EnabledButton = false;
				this.btnAntibodyAdd.SetToolTip(Common.StrRes.Tooltips.UC038.EnterAntibody().ResString);
			}
		}

		private void cbShowInactiveAntibodies_Click(object sender, System.EventArgs e)
		{
			_showInactiveAIs = this.cbShowInactiveAntibodies.Checked;
			this.LoadListView38(Common.TransfusionRequirementCategoryCode.AntibodyIdentified);
		}

		#endregion


		

				
		#endregion
		
		#endregion


		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmDefineTransfusionReqs_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			if (this.patientSelectTool1.Visible)
			{
				textToSpeak = this.btnOK.EnabledButton ? string.Empty : this.btnOK.GetToolTip();
			}
			else
			{
				switch (this.tabTransfusionRequirements.SelectedTab.Name)
				{
					case "pageSpecialInstructions":
					{
						textToSpeak = this.btnAdd.EnabledButton ? string.Empty : this.btnAdd.GetToolTip();	
						break;
					}
					case "pageAntigenNegative":
					{
						textToSpeak = this.btnAddAntigenScreen.EnabledButton ? string.Empty : this.btnAddAntigenScreen.GetToolTip();
						break;
					}
					case "pageComponentAttribute":
					{
						textToSpeak = this.btnAddComponentAttribute.EnabledButton ? string.Empty : this.btnAddComponentAttribute.GetToolTip();	
						break;
					}
					case "pageAntibodyIDs":
					{
						textToSpeak = this.btnAntibodyAdd.EnabledButton ? string.Empty : this.btnAntibodyAdd.GetToolTip();	
						break;
					}
				}
				//
				if (!this.btnOK.EnabledButton)
				{
					textToSpeak = textToSpeak != string.Empty ? string.Concat(textToSpeak, "\n\n", this.btnOK.GetToolTip()) : this.btnOK.GetToolTip();
				}
			}
			if(this.patientDisplayPanel1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak, this.patientDisplayPanel1.GetErrorMessagesFor508());
			}
			if(this.patientSelectTool1.Visible)
			{
				textToSpeak = string.Concat(textToSpeak,this.patientSelectTool1.GetErrorMessagesFor508());
			}
			//
			if (textToSpeak != string.Empty)
			{
				this.SpeakMessage( textToSpeak );
			}
		}

		private void lvInstructions_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvInstructions);
		}

		private void lvAntigenNegative_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvAntigenNegative);
		}

		private void lvComponentAttributes_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvComponentAttributes);
		}

		private void lvAntibodies_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			this.SpeakListViewWithCheckBox(lvAntibodies);
		}

        private void lvInstructions_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_loading == false)
            {
                if (_removeSI)
                {
                    ((ListView) sender).Items.Remove(e.Item);
                    _removeSI = false;
                }
            }
        }

        private void lvAntigenNegative_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_loading == false)
            {
                if (_removeTR)
                {
                    ((ListView)sender).Items.Remove(e.Item);
                    _removeTR = false;
                }
            }
        }

        private void lvComponentAttributes_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_loading == false)
            {
                if (_removeTR)
                {
                    ((ListView)sender).Items.Remove(e.Item);
                    _removeTR = false;
                }
            }
        }

        private void lvAntibodies_ItemChecked(object sender, ItemCheckedEventArgs e)
        {
            if (_loading == false)
            {
                if (_removeTR)
                {
                    ((ListView)sender).Items.Remove(e.Item);
                    _removeTR = false;
                }
            }
        }


	}
}

